# ALESA FRAMEWORK v9.5.0 "STUDENT PRO PLUS"

> **Codename:** Student Pro Plus
> **Status:** Stable / Learning
> **Philosophy:** Safety First. Code with Confidence.

---

## 🏛 THE FOUR PILLARS (STUDENT EDITION)

1.  **SAFEGUARD (Pelindung)**

    - **Rule:** Never edit code without a safety net.
    - **Tool:** `alesa backup`
    - **Protocol:** Pre-Flight & Post-Success backups are mandatory.

2.  **INTEGRITY (Amanah)**

    - **Rule:** Every line of code impacts real lives. Treat it with respect.
    - **Action:** Verify before delivering.

3.  **SIMPLICITY (Mudah)**

    - **Rule:** Use tools that work. Avoid over-engineering.
    - **Focus:** Deliver value quickly and safely.

4.  **LEARNING (Ilmu)**
    - **Rule:** Every mistake is a lesson.
    - **Action:** Record lessons to avoid repeating errors.

---

## 🛡 SAFETY PROTOCOL: THE TWO-POINT CYCLE

To ensure zero data loss and maximum confidence, you MUST follow this cycle for every task.

### 1. PRE-FLIGHT (Before Work)

**Command:** `alesa backup [user] "Pre-[TaskName]"`

- **Purpose:** Safety Net. If you break it, you can revert instantly.
- **Mandatory:** YES.

### 2. POST-SUCCESS (After Verification)

**Command:** `alesa backup [user] "Post-[SuccessTag]"`

- **Purpose:** Save Point. Lock in your progress.
- **Mandatory:** Recommended.

---

## 🛠 CORE TOOLS

### 1. Alesa CLI

The bridge between you and the system.

- `alesa --version` : Check current version.
- `alesa help` : Show available commands.

### 2. Backup System (v2.0)

- **Create:** `alesa backup [user] "[tag]"`
- **List:** `alesa list [user]`
- **Restore:** `alesa restore [user] [timestamp]`

---

## 📜 STANDARD OPERATING PROCEDURE (SOP)

### STARTING A SESSION

1.  **Check Version:** Run `alesa --version`. Ensure it says **v9.5.0**.
2.  **Review Context:** specific context for the project.
3.  **Announce Ready:** "Alesa v9.5.0 Ready."

### ENDING A SESSION

1.  **Final Backup:** Ensure "Post-Success" backup is created.
2.  **Log Lessons:** Note down any new learnings.
3.  **Close:** Confirm all tasks are complete.

---

> "We build to learn. We learn to build safely."
